(function( $ ) {
    'use strict';
    var VisualHaloAnimation = {
        initHalo: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualHaloAnimation.initHaloWidget);
        },
        initHaloWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var haloAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        haloAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                haloAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = haloAnimationArgs.marvy_enable_halo_animation;
                    settings.bgColor = haloAnimationArgs.marvy_halo_animation_background_color;
                    settings.baseColor = haloAnimationArgs.marvy_halo_animation_base_color;
                    settings.size = haloAnimationArgs.marvy_halo_animation_size;
                    settings.amplitudeFactor = haloAnimationArgs.marvy_halo_animation_amplitude_factor;
                    settings.xOffset = haloAnimationArgs.marvy_halo_animation_xOffset;
                    settings.yOffset = haloAnimationArgs.marvy_halo_animation_yOffset;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_halo_animation");
                settings.bgColor = $scope.data("marvy_halo_animation_background_color");
                settings.baseColor = $scope.data("marvy_halo_animation_base_color");
                settings.size = $scope.data("marvy_halo_animation_size");
                settings.amplitudeFactor = $scope.data("marvy_halo_animation_amplitude_factor");
                settings.xOffset = $scope.data("marvy_halo_animation_xOffset");
                settings.yOffset = $scope.data("marvy_halo_animation_yOffset");
            }

            if (settings.switch) {
                haloAnimation(target, settings, sectionId);
            }
        }
    };

    function haloAnimation(target,settings,sectionId) {
        var checkElement = document.getElementsByClassName("marvy-halo-section-" + sectionId);
        if (checkElement.length >= 0) {

            var halo_div = document.createElement('div');
            halo_div.classList.add("marvy-halo-section-" + sectionId);

            document.querySelector(target).appendChild(halo_div);
            document.querySelector(target).classList.add("marvy-custom-halo-animation-section-" + sectionId);

            // Set Z-index for section container
            var haloZindex = document.querySelector('.marvy-custom-halo-animation-section-'+sectionId+' .elementor-container');
            haloZindex.style.zIndex = '99';

            // Set min height
            var haloMinHeight = document.querySelector(".elementor-element-"+sectionId);
            haloMinHeight.closest('.elementor-top-section').style.minHeight = "100px";

            var haloAnimation = VANTA.HALO({
                el: ".marvy-halo-section-" + sectionId,
                mouseControls: true,
                touchControls: true,
                gyroControls: false,
                minHeight: 100.00,
                scale: 1.00,
                scaleMobile: 1.00,
                backgroundColor: settings.bgColor,
                baseColor: settings.baseColor,
                amplitudeFactor: settings.amplitudeFactor,
                xOffset: settings.xOffset,
                yOffset: settings.yOffset,
                size: settings.size
            });
            render(haloAnimation,sectionId);
        }
        return true;
    }

    function render(animation,sectionId) {
        document.querySelector(".elementor-element-"+sectionId).addEventListener('DOMAttrModified', function(e){
            animation.resize();
        }, false);
    }

    $( window ).on('elementor/frontend/init', VisualHaloAnimation.initHalo);
})( jQuery );